use sybsystemprocs
go

if exists (select 1 from sysobjects
           where 
                  name = "sp_gen_repset"
           and    sysstat & 7 = 4 )
begin
   print "Dropping procedure sp_gen_repset"
   drop proc sp_gen_repset
end
go

print "Installing procedure sp_gen_repset"
go

create proc sp_gen_repset
(
 @dbname      varchar(30) = null
)
as 
-- 
-- Permission to use, copy, modify and distribute this code for 
-- NON-commercial purposes and without fee is hereby granted provided
-- that this copyright notice appears in all copies.
-- Sybase shall not be liable for any damages as a result of using,
-- modifying or distributing this code.
--
-- Name : gen_rep_set.sp
-- Auth.: R.Quakkelaar (Sybase Inc.)
-- Vers.: 1.0
-- Date : Feb. 1998
-- Desc.: Generates script to execute sp_setreptable on all user tables in a database.
--

set nocount on

if (@dbname = null)
   select @dbname = db_name()

declare
         @tabid         int
        ,@msg           varchar(255)
        ,@tabname       varchar(30)
      
create table #table_list
(
 id     int
)

insert #table_list 
       select id 
       from sysobjects 
       where type = 'U' 
       and   name not like 'rs_%' 
       order by name

select @tabid = 0

while (select min(id) from #table_list where id > @tabid) != NULL
begin
   select @tabid = min(id) 
   from #table_list where id > @tabid

   select 
          @tabname = object_name(@tabid)

   select @msg = "sp_setreptable"
                 + space(01)
                 + @tabname
                 +","
                 + space(01)
                 + "true"

   print @msg
   print "go"
end

drop table #table_list

return
go

grant execute on sp_gen_repset to public
go

