
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import java.util.Calendar;

public class MqttPublishSample {

    public static void main(String[] args) {

        // Topic to which the MQTT message is published. To work with
        // Informix, the topic represents the database and table using
        // the format of <database>.<table>
        String topic        = "stores_demo.sensor_tab";
        int qos             = 0;
        
        // The broker is the port configured for the Informix MQTT listener
        String broker       = "tcp://localhost:29002";
        
        //
        String clientId     = "JavaSample";
        MemoryPersistence persistence = new MemoryPersistence();
        Calendar calendar;
        java.util.Date now;
        java.sql.Timestamp currentTimestamp;
        
        try {
           MqttClient sampleClient = new MqttClient (broker, clientId, persistence);
           MqttConnectOptions connOpts = new MqttConnectOptions();
           connOpts.setCleanSession(true);
           System.out.println("Connecting to broker: "+ broker);
           sampleClient.connect(connOpts);
           System.out.println("Connected");
        
           for (int i = 0; i < 20; i++) {
              // get the current timestamp
              calendar = Calendar.getInstance();
              now = calendar.getTime();
              currentTimestamp = new java.sql.Timestamp(now.getTime());
              String ts = new String(currentTimestamp.toString());
        
              // For the sensor value, we will use the total amount of
              // free memory available to the JVM */
              String fm = new String (Long.toString(Runtime.getRuntime().freeMemory()));
        
              /* create the JSON document using the various bits. The
              JSON should matches the structure of the database table:
                {
                sensor_id : < >,
                tstamp : < >,
                value : < >
                }
              */

              // Create a string representing the JSON from the various bits
              String content = new String("{sensor_id:23, tstamp:\"" + ts
                + "\", value:\"" + fm + "\" }");
        
              System.out.println("Publishing message: "+ content);
        
              // Publish the JSON document as a message to the database
              // table topic
              MqttMessage message = new MqttMessage(content.getBytes());
        
              message.setQos(qos);
              sampleClient.publish(topic, message);
              System.out.println("Message published");
        
              // Sleep until time to take the next reading. Values are
              // in milliseconds.
              Thread.sleep (1000);
           }
        
        /* Disconnect to clean up when finished. This Java implementation
           is synchronous, and so the message queue is flushed as part of
           the disconnect process. */
        sampleClient.disconnect();
        System.out.println("Disconnected");
        System.exit(0);
        }
        
        // Catch block for the exception that could be thrown from the
        // Thread.sleep() call
        catch (InterruptedException swallowed) {
        }
        
        // Catch block for the MQTT exceptions - just print out some debug info
        catch(MqttException me) {
        System.out.println("reason " + me.getReasonCode());
        System.out.println("msg " + me.getMessage());
        System.out.println("loc " + me.getLocalizedMessage());
        System.out.println("cause " + me.getCause());
        System.out.println("excep " + me);
        me.printStackTrace();
        }
        
    }
}
