﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using IBM.Data.Informix;

namespace ConsoleApplication1
{
    class Program
    {
        private IfxConnection conn;
        static void Main(string[] args)
        {
            Program prg = new Program();
            prg.MakeConnection();
            prg.TruncateTable();
            prg.InsertRows();
            prg.QueryTable();
            prg.UpdDelTable();
            prg.QueryTable();

        }
        public void MakeConnection()
        {
            string ConnectionString = "Host=192.168.96.135; " +
"Service=23177; " +
"Server=demoinf; " +
"Database=justdave; " +
"User Id=informix; " +
"Password=Derff1234; ";
            //Can add other DB parameters here like DELIMIDENT, DB_LOCALE etc
            //Full list in Client SDK's .Net Provider Reference Guide p 3:13
            conn = new IfxConnection();
            conn.ConnectionString = ConnectionString;
            try
            {
                conn.Open();
                Console.WriteLine("Made connection!");
                Console.ReadLine();
            }
            catch (IfxException ex)
            {
                Console.WriteLine("Problem with connection attempt: "
                                  + ex.Message);
            }
        }
        public void TruncateTable()
        {
            IfxCommand cmd;
            cmd = new IfxCommand("truncate table test_table", conn);
            cmd.CommandTimeout = 200; //seconds to wait for command to finish
            try
            {
                int rows = cmd.ExecuteNonQuery();
                Console.WriteLine("Truncated Table!");
                Console.ReadLine();
            }
            catch (IfxException ex)
            {
                Console.WriteLine("Error truncating table " + ex.Message);
            }
        }
        public void InsertRows()
        {
            IfxCommand cmd;
            IfxParameter param;

            cmd = new IfxCommand("insert into test_table values (?)", conn);

            param = new IfxParameter();
            param.IfxType = IfxType.Char;
            param.Value = "justdave";
            cmd.Parameters.Add(param);

            cmd.CommandTimeout = 200; //seconds to wait for command to finish
            try
            {
                int rows = cmd.ExecuteNonQuery();
                Console.WriteLine("Inserted 1st row!");
                Console.ReadLine();
            }
            catch (IfxException ex)
            {
                Console.WriteLine("Error inserting 1st row " + ex.Message);
            }

            param.Value = "FIRST NAME";
            try
            {
                int rows = cmd.ExecuteNonQuery();
                Console.WriteLine("Inserted 2nd row!");
                Console.ReadLine();
            }
            catch (IfxException ex)
            {
                Console.WriteLine("Error inserting 2nd row " + ex.Message);
            }

            param.Value = "SECOND NAME";
            try
            {
                int rows = cmd.ExecuteNonQuery();
                Console.WriteLine("Inserted 3rd row!");
                Console.ReadLine();
            }
            catch (IfxException ex)
            {
                Console.WriteLine("Error inserting 3rd row " + ex.Message);
            }
        }
        public void QueryTable()
        {
            IfxCommand cmd;
            IfxParameter param;

            cmd = new IfxCommand("select name from test_table", conn);
            Console.WriteLine("QueryTable");
            try
            {
                IfxDataReader dr = cmd.ExecuteReader();
                while (dr.Read())
                {
                    string name = (String)dr[0];
                    Console.WriteLine(name);
                }
                dr.Close();
                Console.ReadLine();
            }
            catch (IfxException ex)
            {
                Console.WriteLine("Error querying table" + ex.Message);
            }
        }
        public void UpdDelTable()
        {
            IfxCommand cmdupd;
            IfxParameter param1;
            IfxParameter param2;

            IfxCommand cmddel;

            cmdupd = new IfxCommand("UPDATE test_table SET name=? WHERE name=?", conn);
            cmdupd.CommandTimeout = 200; //seconds to wait for command to finish

            param1 = new IfxParameter();
            param1.IfxType = IfxType.Char;
            param1.Value = "first name";
            cmdupd.Parameters.Add(param1);

            param2 = new IfxParameter();
            param2.IfxType = IfxType.Char;
            param2.Value = "FIRST NAME";
            cmdupd.Parameters.Add(param2);

            Console.WriteLine("Update Table");
            try
            {
                int rows = cmdupd.ExecuteNonQuery();
                Console.WriteLine("Updated table!");
            }
            catch (IfxException ex)
            {
                Console.WriteLine("Error updating table" + ex.Message);
            }

            cmdupd = new IfxCommand("DELETE FROM test_table WHERE name='SECOND NAME'", conn);

            Console.WriteLine("Delete from Table");
            try
            {
                int rows = cmdupd.ExecuteNonQuery();
                Console.WriteLine("Deleted from table!");
            }
            catch (IfxException ex)
            {
                Console.WriteLine("Error deleting from table" + ex.Message);
            }
        }
    }
}
