
-- On server machine 
-- MD C:\DATA
-- MD C:\Backups
-- del C:\Backups\justdave.bak

-- Drop database justdave1 

CREATE DATABASE justdave1;

USE justdave1;

-- New columns 
SELECT socket_count, cores_per_socket, numa_node_count,* FROM sys.dm_os_sys_info;

-- New DMV
-- Host info replaces sys.dm_is_windows_info
SELECT * FROM sys.dm_os_windows_info;
SELECT * FROM sys.dm_os_host_info;

-- New columns

SELECT modified_extent_page_count,* FROM sys.dm_db_file_space_usage;

BACKUP DATABASE [justdave1]
TO DISK = N'C:\Backups\justdave1.bak'
WITH FORMAT,INIT;

SELECT modified_extent_page_count,* FROM sys.dm_db_file_space_usage;

CREATE TABLE dbo.A (b INT);

SELECT modified_extent_page_count,* FROM sys.dm_db_file_space_usage;

BACKUP DATABASE [justdave1]
TO DISK = N'C:\Backups\justdave1.bak'
WITH FORMAT,INIT;

SELECT modified_extent_page_count,* FROM sys.dm_db_file_space_usage;

-- New DMV
-- Version storage usage
SELECT d.name,dtvssu.* 
FROM sys.dm_tran_version_store_space_usage AS dtvssu
JOIN sys.databases AS d
ON dtvssu.database_id = d.database_id
ORDER BY d.name;

-- New DMV
-- VLF info
SELECT * 
FROM sys.dm_db_log_info(DEFAULT);

SELECT d.name,count(l.database_id) as 'vlf_count'
FROM sys.databases d
CROSS APPLY sys.dm_db_log_info(d.database_id) l
group by name
order by vlf_count desc
-- having count(l.database_id)> 100
;

-- New DMV
-- Log summary level attributes and information
SELECT * FROM sys.dm_db_log_stats(DEFAULT);

SELECT d.name,l.*
FROM sys.databases d
CROSS APPLY sys.dm_db_log_stats(d.database_id) l
;

-- New DMV
-- Show statistics histogram

DROP TABLE IF EXISTS dbo.Numbers1;

CREATE TABLE dbo.Numbers1 (
  NumberID int NOT NULL 
 );
 
CREATE CLUSTERED INDEX ix_NumberID1 ON dbo.Numbers1(NumberID);
 
  
WITH
  Pass0 as (select 1 as C union all select 1), --2 rows
  Pass1 as (select 1 as C from Pass0 as A, Pass0 as B),--4 rows
  Pass2 as (select 1 as C from Pass1 as A, Pass1 as B),--16 rows
  Pass3 as (select 1 as C from Pass2 as A, Pass2 as B),--256 rows
  Pass4 as (select 1 as C from Pass3 as A, Pass3 as B),--65536 rows
  Pass5 as (select 1 as C from Pass4 as A, Pass4 as B),--4,294,967,296 rows
  Tally as (select row_number() over(order by C) as Number from Pass5)
INSERT dbo.Numbers1 (NumberID)
 select TOP(1000) Number
  from Tally;

UPDATE STATISTICS dbo.Numbers1 WITH FULLSCAN;

DBCC SHOW_STATISTICS ("dbo.Numbers1", ix_NumberID1)
WITH HISTOGRAM;

SELECT * 
FROM sys.dm_db_stats_histogram(OBJECT_ID('dbo.Numbers1'), 1);


SELECT s.name,h.*
FROM sys.stats AS s
CROSS APPLY sys.dm_db_stats_histogram(s.[object_id], s.stats_id) AS h
WHERE s.[object_id] = OBJECT_ID('dbo.Numbers1'); 
