
-- On server machine 
-- MD C:\DATA
-- MD C:\Backups
-- del C:\Backups\justdave.bak

-- Drop database justdave1 

CREATE DATABASE justdave1;

DROP TABLE IF EXISTS dbo.Numbers1;

CREATE TABLE dbo.Numbers1 (
  NumberID1 int NOT NULL,
  Quantity INT
);

CREATE CLUSTERED COLUMNSTORE INDEX ix_NumberID1 ON dbo.Numbers1;
  
WITH
  Pass0 as (select 1 as C union all select 1), --2 rows
  Pass1 as (select 1 as C from Pass0 as A, Pass0 as B),--4 rows
  Pass2 as (select 1 as C from Pass1 as A, Pass1 as B),--16 rows
  Pass3 as (select 1 as C from Pass2 as A, Pass2 as B),--256 rows
  Pass4 as (select 1 as C from Pass3 as A, Pass3 as B),--65536 rows
  Pass5 as (select 1 as C from Pass4 as A, Pass4 as B),--4,294,967,296 rows
  Tally as (select row_number() over(order by C) as Number from Pass5)
INSERT dbo.Numbers1 (NumberID1,Quantity)
 select TOP(10) Number,1
  from Tally;



WITH
  Pass0 as (select 1 as C union all select 1), --2 rows
  Pass1 as (select 1 as C from Pass0 as A, Pass0 as B),--4 rows
  Pass2 as (select 1 as C from Pass1 as A, Pass1 as B),--16 rows
  Pass3 as (select 1 as C from Pass2 as A, Pass2 as B),--256 rows
  Pass4 as (select 1 as C from Pass3 as A, Pass3 as B),--65536 rows
  Pass5 as (select 1 as C from Pass4 as A, Pass4 as B),--4,294,967,296 rows
  Tally as (select row_number() over(order by C) as Number from Pass5)
INSERT dbo.Numbers1 (NumberID1,Quantity)
 select TOP(100000) Number,2
  from Tally;

ALTER INDEX ix_NumberID1 ON dbo.Numbers1 REORGANIZE;

DROP TABLE IF EXISTS dbo.Numbers2;

CREATE TABLE dbo.Numbers2 (
  NumberID2 int NOT NULL,
);


CREATE NONCLUSTERED INDEX ix_NumberID2
ON [dbo].[Numbers2] ([NumberID2]);

WITH
  Pass0 as (select 1 as C union all select 1), --2 rows
  Pass1 as (select 1 as C from Pass0 as A, Pass0 as B),--4 rows
  Pass2 as (select 1 as C from Pass1 as A, Pass1 as B),--16 rows
  Pass3 as (select 1 as C from Pass2 as A, Pass2 as B),--256 rows
  Pass4 as (select 1 as C from Pass3 as A, Pass3 as B),--65536 rows
  Pass5 as (select 1 as C from Pass4 as A, Pass4 as B),--4,294,967,296 rows
  Tally as (select row_number() over(order by C) as Number from Pass5)
INSERT dbo.Numbers2 (NumberID2)
 select TOP(100000) Number
  from Tally;

ALTER INDEX ix_NumberID2 ON dbo.Numbers2 REORGANIZE;

-- Include Actual Plan 
SELECT a.NumberID1 FROM dbo.Numbers1 AS a
JOIN dbo.Numbers2 AS b
ON a.NumberID1 = b.NumberID2
WHERE a.Quantity =1;


