
-- On server machine 
-- MD C:\DATA
-- MD C:\Backups
-- del C:\Backups\justdave.bak

-- Drop database justdave1 

CREATE DATABASE justdave1;

USE justdave1;

DROP TABLE IF EXISTS dbo.Numbers;

CREATE TABLE dbo.Numbers (
  NumberID int NOT NULL
);

CHECKPOINT;

WITH
  Pass0 as (select 1 as C union all select 1), --2 rows
  Pass1 as (select 1 as C from Pass0 as A, Pass0 as B),--4 rows
  Pass2 as (select 1 as C from Pass1 as A, Pass1 as B),--16 rows
  Pass3 as (select 1 as C from Pass2 as A, Pass2 as B),--256 rows
  Pass4 as (select 1 as C from Pass3 as A, Pass3 as B),--65536 rows
  Pass5 as (select 1 as C from Pass4 as A, Pass4 as B),--4,294,967,296 rows
  Tally as (select row_number() over(order by C) as Number from Pass5)
INSERT dbo.Numbers (NumberID)
 select TOP(15000000) Number
  from Tally;

CREATE CLUSTERED INDEX ix_NumberID1 ON dbo.Numbers(NumberID);

CHECKPOINT;

ALTER INDEX ix_NumberID1 ON dbo.Numbers REBUILD WITH (RESUMABLE = ON);

ALTER INDEX ix_NumberID1 ON dbo.Numbers REBUILD WITH (ONLINE=ON,RESUMABLE = ON);

SELECT percent_complete,page_count,
OBJECT_SCHEMA_NAME(object_id) AS schema_name,
OBJECT_NAME(object_id) AS object_name,
name
FROM sys.index_resumable_operations;


