
-- On server machine 
-- MD C:\DATA
-- MD C:\Backups
-- del C:\Backups\justdave.bak

-- Drop database justdave1 

CREATE DATABASE justdave1;

USE justdave1;

-- turn on clr
sp_configure 'clr enabled';

sp_configure 'clr enabled',1;
RECONFIGURE;
sp_configure 'clr enabled';

-- Check new settings (advanced option)
sp_configure 'show advanced options',1;
reconfigure;

-- default 1  ignore the PERMISSION_SET information on the assemblies, and always interpret them as UNSAFE
sp_configure 'clr strict security';

DROP FUNCTION IF EXISTS dbo.DoubleMe;
DROP ASSEMBLY IF EXISTS Database1;

CREATE ASSEMBLY Database1 
FROM 'C:\x\Database1.dll'
WITH PERMISSION_SET = SAFE;

-- Create a signed assembly

-- Visual Studio 2015
-- File->New->Project->SQL Server
-- Project->Add New Item->SQL CLR C#->SQL CLR# User Defined Function

Name Function DoubleMe

-- Add Code:

using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;

public partial class UserDefinedFunctions
{
    public const double SALES_TAX = .086;

    [SqlFunction()]
    public static SqlDouble  DoubleMe(SqlDouble originalAmount)
    {
        SqlDouble  doubleAmount = originalAmount * 2;

        return doubleAmount;
    }
}

-- Project-Properties->SQLCLR->Signing button
-- Tick Sign the Assembly and create a new key file
-- The key file contains the public/private key used to sign the assembly.

// Build Solution -> C:\Users\David\Documents\Visual Studio 2015\Projects\Database2\Database2\bin\Debug

SELECT SUSER_NAME();

USE master;

DROP ASYMMETRIC KEY SQLCLRTestKey;
CREATE ASYMMETRIC KEY SQLCLRTestKey FROM EXECUTABLE FILE = 'C:\x\Database1.dll';

CREATE LOGIN SQLCLRTestLogin FROM ASYMMETRIC KEY SQLCLRTestKey;    
GRANT UNSAFE ASSEMBLY TO SQLCLRTestLogin;

USE justdave1;
DROP FUNCTION IF EXISTS dbo.DoubleMe;
DROP ASSEMBLY IF EXISTS Database1;

CREATE ASSEMBLY Database1 
FROM 'C:\x\Database1.dll'
WITH PERMISSION_SET = SAFE;

CREATE FUNCTION [dbo].[DoubleMe] (@originalAmount as float)  
RETURNS float
AS EXTERNAL NAME [Database1].[UserDefinedFunctions].[DoubleMe]; 

SELECT dbo.DoubleMe(3);



