
-- On server machine 
-- MD C:\DATA
-- MD C:\Backups
-- del C:\Backups\justdave.bak

-- Drop database justdave1 

CREATE DATABASE justdave1;

USE justdave1;

-- Create node tables

DROP TABLE IF EXISTS SQLPerson;

CREATE TABLE SQLPerson
(
  [PersonID] [int] IDENTITY(1,1) NOT NULL,
  [PersonName] [varchar](100) NULL
)
AS NODE;

DROP TABLE IF EXISTS SQLTopic;

CREATE TABLE SQLTopic
(
  [TopicID] [int] IDENTITY(1,1) NOT NULL,
  [TopicName] [varchar](100) NULL
)
AS NODE;

-- Edge Tables have 3 pseudo columns
-- $edge_id: The id of the edge record
-- $from_id: One of the nodes in the edge record
-- $to_id: The other node in the edge record

DROP TABLE IF EXISTS SQLLikes;
CREATE TABLE SQLLikes
  AS EDGE;

INSERT INTO SQLPerson(PersonName) VALUES ('David Williams');
INSERT INTO SQLTopic(TopicName) VALUES ('Graphs');

INSERT INTO SQLPerson(PersonName) VALUES ('Niko Neugebauer');
INSERT INTO SQLTopic(TopicName) VALUES ('Columnstore');

INSERT into SQLLikes ($to_id,$from_id) values 
  	(
  		(select $node_id from dbo.SQLPerson where PersonName = 'David Williams' ),
  		(select $node_id from dbo.SQLTopic where TopicName='Graphs' ) 
  	),
  	(
  		(select $node_id from dbo.SQLPerson where PersonName = 'Niko Neugebauer' ),
  		(select $node_id from dbo.SQLTopic where TopicName='Columnstore' ) 
  	);

SELECT * FROM SQLPerson;
SELECT * FROM SQLTopic;
SELECT * FROM SQLLikes;

SELECT PersonName,TopicName
FROM SQLPerson,SQLTopic,SQLLikes
WHERE MATCH(SQLTopic-(SQLLikes)->SQLPerson);